import {batchActions} from 'redux-batched-actions';
import flatMap from 'lodash/flatMap';
import times from 'lodash/times';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

import {DIRECTIONS} from 'types/common/EDirection';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {clearOrderInfo} from 'reducers/trains/order/actions/data';
import {setOrderPageStatus} from 'reducers/trains/order/actions/flow';
import {
    setContinueWithoutInsurance,
    setInsuranceIncluded,
} from 'reducers/trains/order/actions/userChoice';
import {clearTrainDetails} from 'reducers/trains/order/actions/trains';

import directionTrainsCountSelector from 'selectors/trains/order/directionTrainsCountSelector';

/**
 * Метод очистки данных заказа и данных о всех поездах
 */
export default function clearOrder(): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const directionTrainsCount = directionTrainsCountSelector(state);

        dispatch(
            batchActions([
                clearOrderInfo(),
                ...flatMap(DIRECTIONS, direction => {
                    const count = directionTrainsCount[direction];

                    return times(count, index =>
                        clearTrainDetails({
                            direction,
                            index,
                            data: undefined,
                        }),
                    );
                }),
                setOrderPageStatus(ORDER_PAGE_STATUSES.FETCHING_DATA),
                setInsuranceIncluded(false),
                setContinueWithoutInsurance(false),
            ]),
        );
    };
}
