import {batchActions} from 'redux-batched-actions';

import {PASSENGERS_TYPE_ORDER} from 'projects/trains/constants/passengersTypes';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setCount} from 'reducers/trains/order/actions/passengers';

import currentTrainDetailsSelector from 'selectors/trains/order/currentTrainDetailsSelector';

import {convertPassengerTypeToTariffType} from 'projects/trains/lib/convertPassengerTypeToTariffType';

/**
 * Очищает типы пассажиров, которых нет в trainDetails.tariffCategories
 */
export function clearPassengersCountByTariffCategories(): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {
            trains: {
                order: {passengers},
            },
        } = state;

        const trainDetails = currentTrainDetailsSelector(state);
        const tariffCategories = trainDetails?.tariffCategories;

        if (!tariffCategories) {
            return;
        }

        const actions = PASSENGERS_TYPE_ORDER.filter(type => {
            const tariffType = convertPassengerTypeToTariffType(type);

            const hasTariffCategory = Boolean(
                tariffCategories.find(category => category.code === tariffType),
            );

            return !hasTariffCategory && passengers[type];
        }).map(type => setCount[type](0));

        if (actions.length) {
            dispatch(batchActions(actions));
        }
    };
}
