import {CustomThunkAction} from 'reducers/trains/customDispatch';

import trainsSelector from 'selectors/trains/order/trainsSelector';
import orderPriceDetailsSelector from 'selectors/trains/order/orderPriceDetailsSelector';

import {logError} from 'utilities/logger/logError';
import mapTrainList from 'projects/trains/lib/complexOrder/mapTrainList';

import {trainsService} from 'serviceProvider';

export default function logBandit(): CustomThunkAction<Promise<void>> {
    return async (dispatch, getState): Promise<void> => {
        const state = getState();
        const trains = trainsSelector(state);
        const orderPriceDetails = orderPriceDetailsSelector(state);

        try {
            const promises = mapTrainList(
                trains,
                async (train, direction, index) => {
                    const {
                        trainDetails: trainDetailsInfo,
                        segment,
                        coach,
                    } = train;
                    const trainDetails = trainDetailsInfo?.trainDetails;

                    if (!segment || !trainDetails || !coach) {
                        return;
                    }

                    const {stationFrom, stationTo} = segment;

                    const {departure, rawTrainName} = trainDetails;

                    const brandTitle =
                        segment?.thread?.deluxeTrain?.shortTitle ||
                        rawTrainName;

                    const priceDetails = orderPriceDetails[direction][index];

                    await trainsService.provider().logBandit({
                        departure,
                        feeCalculationToken: coach.feeCalculationToken,
                        arrival: coach.arrival,
                        stationFromId: Number(stationFrom.id),
                        stationToId: Number(stationTo.id),
                        serviceClass: coach.serviceClass.code,
                        carType: coach.type,
                        price: priceDetails?.price?.value,
                        trainType: brandTitle,
                    });
                },
            );

            await Promise.all(promises);
        } catch (e) {
            logError(
                {
                    message: '[YATRAVEL][TRAINS] Could not log bandit',
                    block: 'logBandit',
                },
                e,
            );
        }
    };
}
