import flatMap from 'lodash/flatMap';

import {ITrainsOrderLocation} from 'types/trains/booking/ITrainsOrderLocation';
import {DIRECTIONS} from 'types/common/EDirection';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {requestTrainDetails} from 'reducers/trains/order/thunk/requestTrainDetails';

/**
 * Загрузить все trainDetails в заказе
 */
export const requestAllTrainDetails =
    (query: ITrainsOrderLocation): CustomThunkAction<void> =>
    async (dispatch): Promise<void> => {
        const promises = flatMap(DIRECTIONS, direction => {
            const routes = query[direction] ?? [];

            return routes.map((route, index) => {
                return dispatch(requestTrainDetails(query, direction, index));
            });
        });

        await Promise.all(promises);
    };
