import {setAvailableCountries} from 'reducers/trains/order/actions/data';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {trainsBrowserProvider} from 'serviceProvider/trains/trainsBrowserProvider';

const requestCountries =
    (): CustomThunkAction<void> =>
    async (dispatch, getState): Promise<void> => {
        const {
            trains: {order},
        } = getState();

        if (order.availableCountries.length) {
            return;
        }

        try {
            const {countries} = await trainsBrowserProvider.countries();

            dispatch(setAvailableCountries(countries));
        } catch (err) {}
    };

export default requestCountries;
