import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {IOrderError} from '../types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setOrderInfo} from 'reducers/trains/order/actions/data';
import {setOrderError} from 'reducers/trains/order/actions/view';

import {isUnknownAxiosError} from 'utilities/error';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export function requestOrderInfo(orderId: string): CustomThunkAction<void> {
    return async function (dispatch): Promise<void> {
        try {
            const genericOrder = await genericOrderBrowserProvider.getOrder({
                orderId,
            });

            dispatch(setOrderInfo(genericOrder));
        } catch (err) {
            dispatch(
                setOrderError(
                    isUnknownAxiosError<IOrderError>(err) && err?.response?.data
                        ? err.response.data
                        : {
                              type: EOrderErrorType.COMMON,
                          },
                ),
            );
        }
    };
}
