import {batchActions} from 'redux-batched-actions';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {updateOrderInfo} from 'reducers/trains/order/actions/data';
import {setOrderError} from 'reducers/trains/order/actions/view';
import {resumeOrderPolling} from 'reducers/trains/order/actions/flow';
import moveToPayment from 'reducers/trains/order/thunk/moveToPayment';

import trainDetailsSelector from 'selectors/trains/trainDetailsSelector';

import {getPaymentError} from 'projects/trains/lib/order/payment';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export function resetPayment(): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const state = getState();
        const {
            trains: {
                order: {orderInfo},
            },
        } = state;
        const trainDetails = trainDetailsSelector(state);

        if (!orderInfo || !trainDetails) {
            return;
        }

        try {
            await dispatch(moveToPayment());

            const order = await genericOrderBrowserProvider.getOrder({
                orderId: orderInfo.id,
            });

            dispatch(
                batchActions([updateOrderInfo(order), resumeOrderPolling()]),
            );
        } catch (e) {
            dispatch(
                setOrderError(
                    getPaymentError(orderInfo, trainDetails?.tariffCategories),
                ),
            );
        }
    };
}
