import {isEqual} from 'lodash';
import {batchActions} from 'redux-batched-actions';

import {PASSENGERS_TYPE_ORDER} from 'projects/trains/constants/passengersTypes';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setCount} from 'reducers/trains/order/actions/passengers';
import {PASSENGERS_DEFAULT_STATE} from 'reducers/trains/order/reducers/passengers';

import {getTrainsStoredPassengersCount} from 'projects/trains/lib/order/passengers/passengersCountStorage';
import getFirstForwardTrainDetails from 'projects/trains/lib/complexOrder/getFirstForwardTrainDetails';

export default function restoreTrainsPassengersCount(): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {
            trains: {order},
        } = getState();
        const {passengers} = order;
        const trainDetails = getFirstForwardTrainDetails(order);

        if (!trainDetails) {
            return;
        }

        const storedPassengers = getTrainsStoredPassengersCount(
            trainDetails.isCppk,
        );

        if (
            isEqual(passengers, PASSENGERS_DEFAULT_STATE) &&
            storedPassengers &&
            !isEqual(passengers, storedPassengers)
        ) {
            dispatch(
                batchActions(
                    PASSENGERS_TYPE_ORDER.map(type =>
                        setCount[type](storedPassengers[type]),
                    ),
                ),
            );
        }
    };
}
