import {EDirection} from 'types/common/EDirection';
import {ITrainsSaveOfferServiceResponse} from 'server/services/TrainsService/types/ITrainsSaveOfferService';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import saveOfferParamsSelector from 'selectors/trains/order/saveOffersParamsSelector';

import {trainsBrowserProvider} from 'serviceProvider/trains/trainsBrowserProvider';

export interface IOfferWithDirectionAndIndex {
    direction: EDirection;
    index: number;
    offer: ITrainsSaveOfferServiceResponse;
}

export default function saveOffers(): CustomThunkAction<
    Promise<IOfferWithDirectionAndIndex[]>
> {
    return async (
        dispatch,
        getState,
    ): Promise<IOfferWithDirectionAndIndex[]> => {
        const state = getState();
        const saveOfferParams = saveOfferParamsSelector(state);

        return Promise.all(
            saveOfferParams.map(async ({direction, index, params}) => ({
                direction,
                index,
                offer: await trainsBrowserProvider.saveOffer(params),
            })),
        );
    };
}
