import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import trainListSelector from 'selectors/trains/order/trainListSelector';

import {reachGoalOnce} from 'utilities/metrika';

export default function sendMetrikaAfterCreateOrder(): CustomThunkAction<
    Promise<void>
> {
    return async (_, getState): Promise<void> => {
        const state = getState();
        const trainList = trainListSelector(state);

        for (const train of trainList) {
            const {coach, orderPlaces} = train;

            // Если у вагона есть схема, но перед этапом бронирования места не были выбраны -
            // отправляем событие в метрику (чтобы понять насколько частый кейс)
            if (coach && coach.schemaId && !orderPlaces.length) {
                reachGoalOnce(ETrainsGoal.PLACES_NOT_CHANGED_BEFORE_RESERVE);
            }
        }
    };
}
