import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setOrderError} from 'reducers/trains/order/actions/view';

import * as i18n from 'i18n/trains-error-page-order';

export function setCancelOrderError(): CustomThunkAction<void> {
    return (dispatch): void => {
        const title = i18n.cancelOrderErrorTitle();

        dispatch(
            setOrderError({
                type: EOrderErrorType.INTERNAL_ERROR,
                title,
            }),
        );
    };
}
