import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setOrderError} from 'reducers/trains/order/actions/view';

import trainDetailsSelector from 'selectors/trains/trainDetailsSelector';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nErrorPageOrderBlock from 'i18n/trains-error-page-order';

import SupportPhone from 'components/SupportPhone/SupportPhone';
import TrainsFeedbackLink from 'projects/trains/components/TrainsFeedbackLink/TrainsFeedbackLink';

export function setOrderCancelledAfterPaidError(
    newOrderInfo: IGenericOrderInfo,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const trainDetails = trainDetailsSelector(getState());

        const feedbackLink = (
            <TrainsFeedbackLink
                orderInfo={newOrderInfo}
                tariffCategories={trainDetails?.tariffCategories}
            >
                {i18nErrorPageOrderBlock.processExceptionStateDescriptionFeedbackDashLink()}
            </TrainsFeedbackLink>
        );

        dispatch(
            setOrderError({
                type: EOrderErrorType.INTERNAL_ERROR,
                message: insertJSXIntoKey(
                    i18nErrorPageOrderBlock.orderDashCancelledDashAfterDashPaid,
                )({
                    supportPhone: <SupportPhone />,
                    feedbackLink,
                    link: false,
                }),
            }),
        );
    };
}
