import {batchActions} from 'redux-batched-actions';

import {ITrainsBookFormValues} from 'types/trains/booking/ITrainsBookFormValues';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setOrderEmail,
    setOrderPhone,
} from 'reducers/trains/order/actions/contacts';

export default function setOrderContacts(
    contacts: ITrainsBookFormValues['contacts'],
): CustomThunkAction<void> {
    return async function (dispatch): Promise<void> {
        if (!contacts) {
            return;
        }

        const {email, phone} = contacts;

        dispatch(
            batchActions([
                setOrderEmail(email || ''),
                setOrderPhone(phone || ''),
            ]),
        );
    };
}
