import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';
import {ITrainsOrderLocation} from 'types/trains/booking/ITrainsOrderLocation';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setTrainsContext} from 'reducers/trains/context/actions';
import trainsParseContext from 'reducers/trains/context/actions/trainsParseContext';
import {fillFormFromContextThunkAction} from 'reducers/trains/searchForm/thunk/fillFormFromContextThunkAction';

import getContextFromOrderUrlParams from 'projects/trains/lib/context/getContextFromOrderUrlParams';

export function setOrderContext(
    query: ITrainsOrderLocation,
): CustomThunkAction<void> {
    return async function (dispatch, getState): Promise<void> {
        const {
            trains: {context},
        } = getState();
        const {when, forwardSegmentId, fromId, toId} = query;

        const isSameContext =
            context.from?.key === fromId && context.to?.key === toId;

        if (isSameContext && isFilledTrainsSearchContext(context) && when) {
            dispatch(
                setTrainsContext({
                    ...context,
                    when,
                    originalWhen: when,
                    forwardSegmentId,
                }),
            );
        } else {
            await dispatch(
                trainsParseContext(getContextFromOrderUrlParams(query)),
            );
        }

        dispatch(fillFormFromContextThunkAction());
    };
}
