import {batchActions} from 'redux-batched-actions';
import {Action} from 'typesafe-actions';

import {
    PASSENGERS_TYPE_ORDER,
    PASSENGERS_TYPES,
} from 'projects/trains/constants/passengersTypes';

import {ITrainsOrderLocation} from 'types/trains/booking/ITrainsOrderLocation';
import {TrainsPassengersCount} from 'reducers/trains/order/types';

import {setCount} from 'reducers/trains/order/actions/passengers';
import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {passengersRestrictions} from 'projects/trains/lib/order/passengers/restrictions';

/*
 * Экшн диспатчит информацию пассажиров в заказе
 */
export function setOrderPassengersDataFromQuery(
    query: ITrainsOrderLocation,
): CustomThunkAction<void> {
    return (dispatch): void => {
        const actions: Action[] = [];

        const restrictions = passengersRestrictions(
            PASSENGERS_TYPE_ORDER.reduce<TrainsPassengersCount>(
                (pass, type) => ({
                    ...pass,
                    [type]: Number(query[type]) || 0,
                }),
                {} as TrainsPassengersCount,
            ),
        );

        if (
            !restrictions.length &&
            PASSENGERS_TYPE_ORDER.some(type => query[type] !== undefined)
        ) {
            PASSENGERS_TYPE_ORDER.forEach(type => {
                const count = query[type];

                if (count !== undefined) {
                    actions.push(setCount[type](count));
                } else if (type === PASSENGERS_TYPES.ADULTS) {
                    actions.push(setCount[PASSENGERS_TYPES.ADULTS](0));
                }
            });
        }

        dispatch(batchActions(actions));
    };
}
