import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setOrderError} from 'reducers/trains/order/actions/view';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/trains-error-page-order';

export function setTimeoutError(): CustomThunkAction<void> {
    return (dispatch): void => {
        reachGoal(ETrainsGoal.ORDER_PAYMENT_TIMEOUT);

        const title = i18nBlock.paymentDashErrorDashTimeoutDashTitle();
        const message = i18nBlock.paymentDashErrorDashTimeoutDashContent();

        dispatch(
            setOrderError({
                type: EOrderErrorType.INTERNAL_ERROR,
                title,
                message,
            }),
        );
    };
}
