import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {resetTrainsPassengersCount} from 'reducers/trains/order/actions/passengers';
import {clearPassengersCountByTariffCategories} from 'reducers/trains/order/thunk/clearPassengersCountByTariffCategories';

import {countPassengersWithPlaces} from 'projects/trains/lib/order/passengers/utils';
import getTrainsMaxAvailablePlacesToPurchaseInCoaches from 'projects/trains/lib/order/coaches/getTrainsMaxAvailablePlacesToPurchaseInCoaches';
import getFirstForwardTrainDetails from 'projects/trains/lib/complexOrder/getFirstForwardTrainDetails';

export default function validateTrainsPassengersCount(): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {
            trains: {order},
        } = getState();
        const {passengers} = order;
        const trainDetails = getFirstForwardTrainDetails(order);

        if (!trainDetails) {
            return;
        }

        /*
         * Выбранное количество мест может быть больше, чем возможно купить в поезде.
         * Например, при попытке бронирования, если места уже выкупил кто-то другой и мест осталось меньше,
         * чем изначально планировалось забронировать.
         */
        if (
            countPassengersWithPlaces(passengers) >
            getTrainsMaxAvailablePlacesToPurchaseInCoaches(
                trainDetails.coaches ?? [],
            )
        ) {
            dispatch(resetTrainsPassengersCount());
        }

        dispatch(clearPassengersCountByTariffCategories());
    };
}
