import {createAsyncAction} from 'typesafe-actions';

import {Request} from '@yandex-data-ui/core/lib/types';
import {TTrainPopularRoutes} from 'types/trains/common/popularRoutes/popularRoutes';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {bunkerService} from 'serviceProvider';

const {
    request: trainsPopularRoutesRequest,
    success: trainsPopularRoutesRequestSuccess,
    failure: trainsPopularRoutesRequestFailure,
} = createAsyncAction(
    'index/trainsPopularRoutes/fetchPending',
    'index/trainsPopularRoutes/fetchResolve',
    'index/trainsPopularRoutes/fetchReject',
)<undefined, TTrainPopularRoutes, undefined>();

export {
    trainsPopularRoutesRequest,
    trainsPopularRoutesRequestSuccess,
    trainsPopularRoutesRequestFailure,
};

export function trainsFetchPopularRoutes(
    req?: Request,
): CustomThunkAction<void> {
    return async dispatch => {
        try {
            dispatch(trainsPopularRoutesRequest());

            const response = await bunkerService
                .provider(req && req.container)
                .getTrainPopularRoutes();

            dispatch(trainsPopularRoutesRequestSuccess(response.popularRoutes));
        } catch (error) {
            dispatch(trainsPopularRoutesRequestFailure());
        }
    };
}
