import {getType} from 'typesafe-actions';

import {
    ITrainPopularRoutesWithState,
    ETrainPopularRoutesState,
} from 'reducers/trains/popularRoutes/types';

import {ProjectAction} from 'reducers/storeTypes';
import {
    trainsPopularRoutesRequest,
    trainsPopularRoutesRequestSuccess,
    trainsPopularRoutesRequestFailure,
} from 'reducers/trains/popularRoutes/actions';

const initialState: ITrainPopularRoutesWithState = {
    items: [],
    state: ETrainPopularRoutesState.INITIAL,
};

export default function popularRoutes(
    state: ITrainPopularRoutesWithState = initialState,
    action: ProjectAction,
) {
    switch (action.type) {
        case getType(trainsPopularRoutesRequest): {
            return {
                ...state,
                state: ETrainPopularRoutesState.PENDING,
            };
        }

        case getType(trainsPopularRoutesRequestSuccess): {
            return {
                ...state,
                items: action.payload,
                state: ETrainPopularRoutesState.RESOLVE,
            };
        }

        case getType(trainsPopularRoutesRequestFailure): {
            return {
                ...state,
                items: [],
                state: ETrainPopularRoutesState.REJECT,
            };
        }

        default: {
            return state;
        }
    }
}
