import {createReducer} from 'typesafe-actions';

import {ITrainsPreviousSearch} from 'types/trains/previousSearches/IPreviousSearch';

import {
    setPreviousSearchesAction,
    TTrainsPreviousSearchesActions,
} from 'reducers/trains/previousSearches/actions';

export interface ITrainsPreviousSearchesStore {
    items: ITrainsPreviousSearch[] | null;
}

const INITIAL_STATE: ITrainsPreviousSearchesStore = {
    items: null,
};

export default createReducer<
    ITrainsPreviousSearchesStore,
    TTrainsPreviousSearchesActions
>(INITIAL_STATE).handleAction(
    setPreviousSearchesAction,
    (state, {payload}) => ({
        ...state,
        items: payload,
    }),
);
