import {ITrainsPreviousSearch} from 'types/trains/previousSearches/IPreviousSearch';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setPreviousSearchesAction} from 'reducers/trains/previousSearches/actions';

import getPreviousSearchKey from 'projects/trains/lib/previousSearches/getPreviousSearchKey';
import storePreviousSearches from 'projects/trains/lib/previousSearches/storePreviousSearches';

const TRAINS_PREVIOUS_SEARCHES_COUNT = 3;

export default function addPreviousSearchThunkAction(
    previousSearch: ITrainsPreviousSearch,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {
            trains: {
                previousSearches: {items: currentPreviousSearches},
            },
        } = getState();

        if (!currentPreviousSearches) {
            return;
        }

        const uniqPreviousSearches = currentPreviousSearches.filter(
            currentPreviousSearch =>
                getPreviousSearchKey(currentPreviousSearch) !==
                getPreviousSearchKey(previousSearch),
        );

        const newPreviousSearches = [
            previousSearch,
            ...uniqPreviousSearches,
        ].slice(0, TRAINS_PREVIOUS_SEARCHES_COUNT);

        dispatch(setPreviousSearchesAction(newPreviousSearches));

        storePreviousSearches(newPreviousSearches);
    };
}
