import {batchActions} from 'redux-batched-actions';

import {ITrainsPreviousSearch} from 'types/trains/previousSearches/IPreviousSearch';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setTrainsSearchFormFromFieldAction,
    setTrainsSearchFormStartDateFieldAction,
    setTrainsSearchFormToFieldAction,
    setTrainsSearchFormEndDateFieldAction,
    setTrainsSearchFormIsRoundTripFieldAction,
} from 'reducers/trains/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

export default function fillSearchFormByPreviousSearchThunkAction(
    previousSearch: ITrainsPreviousSearch,
): CustomThunkAction<void> {
    const {endDate} = previousSearch;

    return (dispatch): void => {
        dispatch(
            batchActions([
                setTrainsSearchFormFromFieldAction({
                    inputValue: previousSearch.from.title,
                    source: ESuggestSource.PRESETS,
                    selectedValue: previousSearch.from,
                }),
                setTrainsSearchFormToFieldAction({
                    inputValue: previousSearch.to.title,
                    source: ESuggestSource.PRESETS,
                    selectedValue: previousSearch.to,
                }),
                setTrainsSearchFormStartDateFieldAction(
                    previousSearch.startDate,
                ),
                setTrainsSearchFormEndDateFieldAction(endDate || null),
                setTrainsSearchFormIsRoundTripFieldAction(Boolean(endDate)),
            ]),
        );
    };
}
