import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setPreviousSearchesAction} from 'reducers/trains/previousSearches/actions';
import restorePreviousSearches from 'reducers/trains/previousSearches/thunk/utilities/restorePreviousSearches';

export default function restorePreviousSearchesThunkAction(): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const state = getState();
        const {
            trains: {
                previousSearches: {items},
            },
        } = state;

        if (items) {
            return;
        }

        dispatch(setPreviousSearchesAction(restorePreviousSearches()));
    };
}
