import moment from 'moment';

export default function isActualEndDate(
    startDate: string | null,
    endDate: string | null,
): boolean {
    if (!startDate) {
        return false;
    }

    if (!endDate) {
        return true;
    }

    return moment(endDate).isSameOrAfter(moment(startDate), 'day');
}
