import moment, {Moment} from 'moment';

/**
 * Проверяет актуальность даты для поездки
 * @param startDate - дата выезда
 * @param nowMoment - текущий момент времени
 * @link https://st.yandex-team.ru/TRAVELFRONT-6145
 */
export default function isActualStartDate(
    startDate: string | null,
    nowMoment: Moment,
): boolean {
    if (!startDate) {
        return false;
    }

    return moment(startDate).isSameOrAfter(nowMoment, 'day');
}
