import moment from 'moment';
import * as localStorage from 'local-storage';

import {ITrainsPreviousSearch} from 'types/trains/previousSearches/IPreviousSearch';

import isActualStartDate from 'reducers/trains/previousSearches/thunk/utilities/isActualStartDate';
import isActualEndDate from 'reducers/trains/previousSearches/thunk/utilities/isActualEndDate';

import {getNow} from 'utilities/dateUtils';
import {logError} from 'utilities/logger/logError';
import storePreviousSearches, {
    TRAINS_STORED_SEARCHES_KEY,
} from 'projects/trains/lib/previousSearches/storePreviousSearches';
import {unknownErrToString} from 'utilities/error';

export default function restorePreviousSearches(): ITrainsPreviousSearch[] {
    try {
        if (typeof window === 'undefined') {
            return [];
        }

        const parsedStoredSearches =
            localStorage.get<ITrainsPreviousSearch[]>(
                TRAINS_STORED_SEARCHES_KEY,
            ) || [];

        const nowMoment = moment(getNow());

        return parsedStoredSearches.filter(storedSearch => {
            const {startDate, endDate} = storedSearch;

            return (
                isActualStartDate(startDate, nowMoment) &&
                isActualEndDate(startDate, endDate)
            );
        });
    } catch (error) {
        storePreviousSearches([]);

        logError({message: unknownErrToString(error)}, error);

        return [];
    }
}
