import {createAction, createAsyncAction} from 'typesafe-actions';

import {ITrainsStartPriceCalendarActionPayload} from './types';
import {ITrainsPriceCalendar} from 'types/trains/search/priceCalendar/ITrainsPriceCalendar';

/* Fetch info */
export const trainsFetchPriceCalendarActions = createAsyncAction(
    'trains/priceCalendar/start',
    'trains/priceCalendar/success',
    'trains/priceCalendar/failed',
)<ITrainsStartPriceCalendarActionPayload, ITrainsPriceCalendar, void>();

/* Clear result */
export const trainsPriceCalendarClearAction = createAction(
    'trains/priceCalendar/clear',
)();
