import {createReducer, ActionType} from 'typesafe-actions';

import {EDirection} from 'types/common/EDirection';
import {ITrainsPriceCalendar} from 'types/trains/search/priceCalendar/ITrainsPriceCalendar';

import * as actions from './actions';

export interface ITrainsPriceCalendarReducer extends ITrainsPriceCalendar {}

/* Initial State */
const initialState: ITrainsPriceCalendarReducer = {
    [EDirection.FORWARD]: {
        dates: [],
    },
    [EDirection.BACKWARD]: {
        dates: [],
    },
};

/* Reducer */
const trainsPriceCalendarReducer = createReducer<
    ITrainsPriceCalendarReducer,
    ActionType<typeof actions>
>(initialState)
    .handleAction(
        actions.trainsFetchPriceCalendarActions.request,
        () => initialState,
    )
    .handleAction(
        actions.trainsFetchPriceCalendarActions.success,
        (state, {payload}) => {
            return {
                ...payload,
            };
        },
    )
    .handleAction(
        actions.trainsFetchPriceCalendarActions.failure,
        () => initialState,
    )
    .handleAction(actions.trainsPriceCalendarClearAction, () => initialState);

export default trainsPriceCalendarReducer;
