import {combineReducers} from 'redux';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import searchForm from 'reducers/trains/searchForm/reducer';
import loadableReducer from 'reducers/utils/loadableReducers/loadableReducer';

export default combineReducers({
    searchForm,
    searchSuggests: loadableReducer(ELoadableReducer.TRAINS_SEARCH_SUGGESTS),
    popularDirections: loadableReducer(
        ELoadableReducer.TRAINS_POPULAR_DIRECTION,
    ),
    popularRoutes: loadableReducer(ELoadableReducer.TRAINS_POPULAR_ROUTES),
    order: loadableReducer(ELoadableReducer.TRAINS_ORDER),
    view: loadableReducer(ELoadableReducer.TRAINS_VIEW),
    search: loadableReducer(ELoadableReducer.TRAINS_SEARCH),
    context: loadableReducer(ELoadableReducer.TRAINS_CONTEXT),
    userActions: loadableReducer(ELoadableReducer.TRAINS_USER_ACTIONS),
    trainsPartner: loadableReducer(ELoadableReducer.TRAINS_PARTNER),
    genericSearch: loadableReducer(ELoadableReducer.TRAINS_GENERIC_SEARCH),
    previousSearches: loadableReducer(
        ELoadableReducer.TRAINS_PREVIOUS_SEARCHES,
    ),
    firmTrain: loadableReducer(ELoadableReducer.TRAINS_FIRM_TRAIN),
    direction: loadableReducer(ELoadableReducer.TRAINS_DIRECTION),
    priceCalendar: loadableReducer(ELoadableReducer.TRAINS_PRICE_CALENDAR),
});
