import {isEqual} from 'lodash';
import {createAction} from 'typesafe-actions';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ITrainsSearchLocation} from 'types/trains/search/ITrainsSearchLocation';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import parseTrainsSortingQuery from 'projects/trains/lib/sort/parseTrainsSortingQuery';
import {reachGoal} from 'utilities/metrika';

export const setSorting = createAction(
    'trains/search/setSorting',
)<ITrainsSearchSort>();

export const changeSortReachGoal = ({
    sort,
    sortToSet,
}: {
    sort: ITrainsSearchSort;
    sortToSet: ITrainsSearchSort;
}): void => {
    if (sort.by !== sortToSet.by) {
        reachGoal(ETrainsGoal.SORTING_TITLE_CLICK);
    }

    if (sort.isReverse !== sortToSet.isReverse) {
        reachGoal(ETrainsGoal.SORTING_ORDER_CLICK);
    }
};

export function setSortingFromRequest(
    query: ITrainsSearchLocation,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const prevSort = getState().trains.search.sort;
        const nextSort = parseTrainsSortingQuery(query.sortBy);

        if (!isEqual(prevSort, nextSort)) {
            dispatch(setSorting(nextSort));
        }
    };
}
