import {getType} from 'typesafe-actions';

import {TRAINS_SEARCH_DEFAULT_SORT} from 'projects/trains/lib/sort/constants';

import {TrainsSearchInterface} from 'reducers/trains/trainsReducerTypes';
import {ProjectAction} from 'reducers/storeTypes';
import {resetSearch} from 'reducers/trains/search/actions';
import {setSorting} from 'reducers/trains/search/actions/sorting';

export const defaultState: TrainsSearchInterface = {
    sort: TRAINS_SEARCH_DEFAULT_SORT,
};

export default function search(
    state: TrainsSearchInterface = defaultState,
    action: ProjectAction,
): TrainsSearchInterface {
    switch (action.type) {
        case getType(resetSearch): {
            return {...defaultState};
        }

        case getType(setSorting): {
            return {
                ...state,
                sort: action.payload,
            };
        }

        default:
            return state;
    }
}
