import {ActionType, createAction} from 'typesafe-actions';

import {ITrainsSearchFormPointField} from 'projects/trains/components/SearchForm/types';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

export const setTrainsSearchFormFromFieldAction = createAction(
    'TRAINS.SEARCH_FORM.SET_FROM',
)<ITrainsSearchFormPointField>();
export const setTrainsSearchFormToFieldAction = createAction(
    'TRAINS.SEARCH_FORM.SET_TO',
)<ITrainsSearchFormPointField>();
export const setTrainsSearchFormStartDateFieldAction = createAction(
    'TRAINS.SEARCH_FORM.SET_START_DATE',
)<WHEN_SPECIAL_VALUE | string | null>();
export const setTrainsSearchFormEndDateFieldAction = createAction(
    'TRAINS.SEARCH_FORM.SET_END_DATE',
)<WHEN_SPECIAL_VALUE | string | null>();
export const setTrainsSearchFormIsRoundTripFieldAction = createAction(
    'TRAINS.SEARCH_FORM.SET_IS_ROUND_TRIP',
)<boolean>();

const reducerActions = {
    setTrainsSearchFormFromFieldAction,
    setTrainsSearchFormToFieldAction,
    setTrainsSearchFormStartDateFieldAction,
    setTrainsSearchFormEndDateFieldAction,
    setTrainsSearchFormIsRoundTripFieldAction,
};

export type TTrainsSearchFormActions = ActionType<typeof reducerActions>;
