import {createReducer} from 'typesafe-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {ITrainsSearchFormValues} from 'projects/trains/components/SearchForm/types';

import {
    setTrainsSearchFormFromFieldAction,
    setTrainsSearchFormStartDateFieldAction,
    setTrainsSearchFormEndDateFieldAction,
    setTrainsSearchFormToFieldAction,
    setTrainsSearchFormIsRoundTripFieldAction,
    TTrainsSearchFormActions,
} from 'reducers/trains/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

const INITIAL_STATE: ITrainsSearchFormValues = {
    [ESearchFormFieldName.FROM]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.TO]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.START_DATE]: null,
    [ESearchFormFieldName.END_DATE]: null,
    isRoundTrip: false,
};

export default createReducer<ITrainsSearchFormValues, TTrainsSearchFormActions>(
    INITIAL_STATE,
)
    .handleAction(setTrainsSearchFormFromFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.FROM]: payload,
    }))
    .handleAction(setTrainsSearchFormToFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.TO]: payload,
    }))
    .handleAction(
        setTrainsSearchFormStartDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.START_DATE]: payload,
        }),
    )
    .handleAction(
        setTrainsSearchFormEndDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.END_DATE]: payload,
        }),
    )
    .handleAction(
        setTrainsSearchFormIsRoundTripFieldAction,
        (state, {payload}) => ({
            ...state,
            isRoundTrip: payload,
        }),
    );
