import {ActionType, createAsyncAction} from 'typesafe-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';

export interface IGetSearchSuggestsRequestAction {
    part: string;
    clientCity: string;
    otherPoint: string;
}

export const getSearchSuggestsActions = createAsyncAction(
    'common/trains/searchSuggestsRequest',
    'common/trains/searchSuggestsRequestSuccess',
    'common/trains/searchSuggestsRequestFailure',
)<
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
        requestParams: IGetSearchSuggestsRequestAction;
    },
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
        items: ITrainsSuggest[];
    },
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
    }
>();

const reducerActions = {
    ...getSearchSuggestsActions,
};

export type TTrainsSearchSuggestsActions = ActionType<typeof reducerActions>;
