import {createReducer} from 'typesafe-actions';

import {TAsyncStore} from 'reducers/types/TAsyncStore';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';

import {
    getSearchSuggestsActions,
    IGetSearchSuggestsRequestAction,
    TTrainsSearchSuggestsActions,
} from 'reducers/trains/searchSuggests/actions';

export interface ITrainsSearchSuggestsStore {
    [ESearchFormFieldName.FROM]: TAsyncStore<
        ITrainsSuggest[],
        IGetSearchSuggestsRequestAction
    >;
    [ESearchFormFieldName.TO]: TAsyncStore<
        ITrainsSuggest[],
        IGetSearchSuggestsRequestAction
    >;
}

const defaultFieldValue: TAsyncStore<
    ITrainsSuggest[],
    TTrainsSearchSuggestsActions
> = {
    value: null,
    isLoading: false,
    isNotFound: false,
    requestParams: null,
    isFailed: false,
    isFetched: false,
};

const INITIAL_STATE = {
    [ESearchFormFieldName.FROM]: defaultFieldValue,
    [ESearchFormFieldName.TO]: defaultFieldValue,
};

export default createReducer<
    ITrainsSearchSuggestsStore,
    TTrainsSearchSuggestsActions
>(INITIAL_STATE)
    .handleAction(
        getSearchSuggestsActions.request,
        (state, {payload: {fieldType, requestParams}}) => ({
            ...state,
            [fieldType]: {
                value: null,
                requestParams,
                isLoading: true,
                isFetched: false,
                isFailed: false,
                isNotFound: false,
            },
        }),
    )
    .handleAction(getSearchSuggestsActions.success, (state, {payload}) => {
        return {
            ...state,
            [payload.fieldType]: {
                ...state[payload.fieldType],
                value: payload.items,
                isLoading: false,
                isFetched: true,
            },
        };
    })
    .handleAction(getSearchSuggestsActions.failure, (state, {payload}) => ({
        ...state,
        [payload.fieldType]: {
            ...state[payload.fieldType],
            isLoading: false,
            isFetched: true,
            isFailed: true,
        },
    }));
