import {ETrainsPartner} from 'projects/trains/constants/trainPartners';

import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {TTrainsFirmTrainStore} from 'reducers/trains/firmTrain/types';
import {ITrainsDirectionStore} from 'reducers/trains/direction/types';
import {TrainsSearchContextType} from 'reducers/trains/context/types';
import {ITrainPopularRoutesWithState} from 'reducers/trains/popularRoutes/types';
import {ITrainsSearchFormValues} from 'projects/trains/components/SearchForm/types';

import {TrainsOrderStateInterface} from 'reducers/trains/order/reducer';
import {ITrainsSearchSuggestsStore} from 'reducers/trains/searchSuggests/reducer';
import {ITrainsPreviousSearchesStore} from 'reducers/trains/previousSearches/reducer';
import {ITrainsGenericSearchReducer} from 'reducers/trains/genericSearch/ITrainsGenericSearchReducer';
import {ITrainsPriceCalendarReducer} from 'reducers/trains/priceCalendar/reducer';

export interface TrainsSearchInterface {
    sort: ITrainsSearchSort;
}

export interface TrainsViewInterface {
    calendarVisibility: boolean;
}

export interface StoredTrainAction {
    type: string;
    data: any;
}

export interface ITrains {
    searchForm: ITrainsSearchFormValues;
    searchSuggests: ITrainsSearchSuggestsStore;
    popularRoutes: ITrainPopularRoutesWithState;
    order: TrainsOrderStateInterface;
    view: TrainsViewInterface;
    search: TrainsSearchInterface;
    context: TrainsSearchContextType;
    userActions: StoredTrainAction[];
    trainsPartner: ETrainsPartner | null;
    genericSearch: ITrainsGenericSearchReducer;
    previousSearches: ITrainsPreviousSearchesStore;
    firmTrain: TTrainsFirmTrainStore;
    direction: ITrainsDirectionStore;
    priceCalendar: ITrainsPriceCalendarReducer;
}
