import {getType} from 'typesafe-actions';

import {TrainsViewInterface} from 'reducers/trains/trainsReducerTypes';
import {setTrainsCalendarVisibility} from 'reducers/trains/view/actions';
import {ProjectAction} from 'reducers/storeTypes';

const DEFAULT_STATE: TrainsViewInterface = {
    calendarVisibility: true,
};

export default function context(
    state: TrainsViewInterface = DEFAULT_STATE,
    action: ProjectAction,
): TrainsViewInterface {
    switch (action.type) {
        case getType(setTrainsCalendarVisibility):
            return {
                ...state,
                calendarVisibility: action.payload,
            };

        default:
            return state;
    }
}
