import {createReducer} from 'typesafe-actions';

import TTripListItem from 'types/trips/TTripListItem/TTripListItem';

import {
    TActiveTripsActionsTypes,
    getActiveTrips,
} from 'reducers/trips/activeTrips/actions';

export interface IActiveTripsState {
    data: TTripListItem[];
    isLoading: boolean;
    isError: boolean;
}

const initialState: IActiveTripsState = {
    data: [],
    isLoading: true,
    isError: false,
};

export default createReducer<IActiveTripsState, TActiveTripsActionsTypes>(
    initialState,
)
    .handleAction(getActiveTrips.request, state => {
        return {...state, isLoading: true, isError: false};
    })
    .handleAction(getActiveTrips.success, (state, action) => {
        return {
            ...state,
            data: action.payload,
            isLoading: false,
            isError: false,
        };
    })
    .handleAction(getActiveTrips.failure, state => {
        return {...state, isLoading: false, isError: true};
    });
