import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getActiveTrips} from 'reducers/trips/activeTrips/actions';

import {trips} from 'serviceProvider/trips/tripsProvider';

export function fetchActiveTrips(req?: Request): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getActiveTrips.request());

            const res = await trips.provider(req?.container).getActiveTrips();

            dispatch(getActiveTrips.success(res.trips));
        } catch (e) {
            dispatch(getActiveTrips.failure());
        }
    };
}
