import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import IGetTripRequestRequest from 'server/api/TripsApi/types/IGetTripRequestRequest';
import ITrip from 'types/trips/ITrip';

export const getTrip = createAsyncAction(
    'trips/tripPage/getTrip/request',
    'trips/tripPage/getTrip/success',
    'trips/tripPage/getTrip/failure',
)<IGetTripRequestRequest, ITrip, number | undefined>();

export const clearTrip = createAction('trips/tripPage/clearTrip')();

export const hideHotelCrossSaleBlock = createAction(
    'trips/tripPage/hideHotelsCrossSaleBlock',
)<string>();

export const restoreHiddenHotelsCrossSaleBlocks = createAction(
    'trips/tripPage/restoreHiddenHotelsCrossSale',
)<string[]>();

export const setIsNewTrip = createAction(
    'trips/tripPage/setIsNewTrip',
)<boolean>();

export type TTripActionsTypes =
    | ActionType<typeof getTrip>
    | ActionType<typeof clearTrip>
    | ActionType<typeof hideHotelCrossSaleBlock>
    | ActionType<typeof restoreHiddenHotelsCrossSaleBlocks>
    | ActionType<typeof setIsNewTrip>;
