import {createReducer} from 'typesafe-actions';

import ITrip from 'types/trips/ITrip';
import {EHttpStatusCodes} from 'types/httpStatusCodes';

import {
    getTrip,
    clearTrip,
    hideHotelCrossSaleBlock,
    restoreHiddenHotelsCrossSaleBlocks,
    setIsNewTrip,
    TTripActionsTypes,
} from 'reducers/trips/tripPage/actions';

export interface ITripState {
    value: ITrip | null;
    isLoading: boolean;
    isFailed: boolean;
    status: number | null;
}

export interface ITripPageState {
    trip: ITripState;
    /** Массив из tripId, для которых пользователь скрыл кросс-сейл отелей */
    hiddenHotelCrossSaleBlocks: string[];
    /** Флаг, есть ли непросмотренная новая поездка */
    isNewTrip: boolean;
}

const initialState: ITripPageState = {
    trip: {
        value: null,
        isLoading: false,
        isFailed: false,
        status: null,
    },
    hiddenHotelCrossSaleBlocks: [],
    isNewTrip: false,
};

export default createReducer<ITripPageState, TTripActionsTypes>(initialState)
    .handleAction(getTrip.request, state => {
        return {
            ...state,
            trip: {
                value: null,
                isLoading: true,
                isFailed: false,
                status: null,
            },
        };
    })
    .handleAction(getTrip.success, (state, {payload}) => {
        return {
            ...state,
            trip: {
                value: payload,
                isLoading: false,
                isFailed: false,
                status: EHttpStatusCodes.Ok,
            },
        };
    })
    .handleAction(getTrip.failure, (state, {payload}) => {
        return {
            ...state,
            trip: {
                value: null,
                isLoading: false,
                isFailed: true,
                status: payload ?? null,
            },
        };
    })
    .handleAction(clearTrip, state => {
        return {
            ...state,
            trip: initialState.trip,
        };
    })
    .handleAction(hideHotelCrossSaleBlock, (state, {payload}) => {
        return {
            ...state,
            hiddenHotelCrossSaleBlocks: [
                ...state.hiddenHotelCrossSaleBlocks,
                payload,
            ],
        };
    })
    .handleAction(restoreHiddenHotelsCrossSaleBlocks, (state, {payload}) => {
        return {
            ...state,
            hiddenHotelCrossSaleBlocks: payload,
        };
    })
    .handleAction(setIsNewTrip, (state, {payload}) => {
        return {
            ...state,
            isNewTrip: payload,
        };
    });
