import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import IGetTripsApiResponse from 'server/api/TripsApi/types/IGetTripsApiResponse';
import IGetMoreTripsApiResponse from 'server/api/TripsApi/types/IGetMoreTripsApiResponse';

export const getTripsList = createAsyncAction(
    'trips/getTripsList/request',
    'trips/getTripsList/success',
    'trips/getTripsList/failure',
)<undefined, IGetTripsApiResponse, undefined>();

export const getMoreTripsList = createAsyncAction(
    'trips/getMoreTripsList/request',
    'trips/getMoreTripsList/success',
    'trips/getMoreTripsList/failure',
)<undefined, IGetMoreTripsApiResponse, undefined>();

export const resetTripsList = createAction('trips/resetTripsList')();

export type TTripsListActionsTypes =
    | ActionType<typeof getTripsList>
    | ActionType<typeof getMoreTripsList>
    | ActionType<typeof resetTripsList>;
