import {createReducer} from 'typesafe-actions';

import IGetTripsApiResponse from 'server/api/TripsApi/types/IGetTripsApiResponse';
import ETripListStatus from 'reducers/trips/tripsList/types/ETripListStatus';

import concatTripLists from 'reducers/trips/tripsList/utilities/concatTripLists';

import {
    getMoreTripsList,
    getTripsList,
    resetTripsList,
    TTripsListActionsTypes,
} from './actions';

export interface ITripsListState {
    data: IGetTripsApiResponse;
    status: ETripListStatus;
}

const emptyTripList = {
    trips: [],
    continuationToken: null,
};

const initialState: ITripsListState = {
    data: {
        active: emptyTripList,
        past: emptyTripList,
    },
    status: ETripListStatus.LOADING,
};

export default createReducer<ITripsListState, TTripsListActionsTypes>(
    initialState,
)
    .handleAction(getTripsList.request, state => {
        return {...state, status: ETripListStatus.LOADING};
    })
    .handleAction(getTripsList.success, (state, action) => {
        return {
            ...state,
            data: action.payload,
            status: ETripListStatus.FETCHED,
        };
    })
    .handleAction(getTripsList.failure, state => {
        return {...state, status: ETripListStatus.ERROR};
    })
    .handleAction(getMoreTripsList.request, state => {
        return {...state, status: ETripListStatus.LOADING_MORE};
    })
    .handleAction(getMoreTripsList.success, (state, action) => {
        return {
            ...state,
            data: {
                active: concatTripLists(
                    state.data.active,
                    action.payload.active,
                ),
                past: concatTripLists(state.data.past, action.payload.past),
            },
            status: ETripListStatus.FETCHED,
        };
    })
    .handleAction(getMoreTripsList.failure, state => {
        return {...state, status: ETripListStatus.ERROR};
    })
    .handleAction(resetTripsList, () => initialState);
