import {Request} from '@yandex-data-ui/core/lib/types';
import IGetTripsRequest from 'server/services/TripsService/types/IGetTripsRequest';
import IGetMoreTripsRequest from 'server/services/TripsService/types/IGetMoreTripsRequest';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {trips} from 'serviceProvider/trips/tripsProvider';

import {getMoreTripsList, getTripsList} from './actions';

export function fetchTripsList(
    params: IGetTripsRequest,
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getTripsList.request());

            const res = await trips.provider(req?.container).getTrips(params);

            dispatch(getTripsList.success(res));
        } catch (e) {
            dispatch(getTripsList.failure());
        }
    };
}

export function fetchMoreTripsList(
    params: IGetMoreTripsRequest,
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        try {
            dispatch(getMoreTripsList.request());

            const res = await trips
                .provider(req?.container)
                .getMoreTrips(params);

            dispatch(getMoreTripsList.success(res));
        } catch (e) {
            dispatch(getMoreTripsList.failure());
        }
    };
}
