import IPaginatedTripsList from 'types/trips/IPaginatedTripsList';

/**
 * Соединяет догруженные списки поездок к исходному списку
 * @param sourceList
 * @param addList
 */
export default function concatTripLists(
    sourceList: IPaginatedTripsList,
    addList: IPaginatedTripsList,
): IPaginatedTripsList {
    return {
        trips: [...sourceList.trips, ...addList.trips],
        continuationToken: addList.continuationToken,
    };
}
