export interface IAsyncStoreBase {
    value: null;
    requestParams: null;
    isLoading: false;
    isFetched: false;
    isFailed: false;
    isNotFound: false;
}

export interface IAsyncStoreFetching<RequestParams> {
    value: null;
    requestParams: RequestParams;
    isLoading: true;
    isFetched: false;
    isFailed: false;
    isNotFound: false;
}

export interface IAsyncStoreSuccess<Response, RequestParams> {
    value: Response;
    requestParams: RequestParams | null;
    isLoading: false;
    isFetched: true;
    isFailed: false;
    isNotFound: false;
}

export interface IAsyncStoreFailure<RequestParams> {
    value: null;
    requestParams: RequestParams | null;
    isLoading: false;
    isFetched: true;
    isFailed: true;
    isNotFound: boolean;
}

export type TAsyncStore<Response, RequestParams> =
    | IAsyncStoreBase
    | IAsyncStoreFetching<RequestParams>
    | IAsyncStoreSuccess<Response, RequestParams>
    | IAsyncStoreFailure<RequestParams>;

export const EMPTY_ASYNC_STATE: IAsyncStoreBase = {
    value: null,
    requestParams: null,
    isLoading: false,
    isFetched: false,
    isFailed: false,
    isNotFound: false,
};
