import {Reducer} from 'typesafe-actions';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

type TLoadableReducers = Record<ELoadableReducer, Reducer<any, any> | null>;

const loadableReducersStorage: TLoadableReducers = (
    Object.values(ELoadableReducer) as ELoadableReducer[]
).reduce(
    (accReducers, reducerName) => ({
        ...accReducers,
        [reducerName]: null,
    }),
    {} as TLoadableReducers,
);

export default loadableReducersStorage;
