import {AnyAction, Reducer} from 'redux';
import {getType} from 'typesafe-actions';

import {resetState} from 'reducers/utils/resetState/actions';

export function getResetStateReducer<S>(rootReducer: Reducer<S>): Reducer<S> {
    return (state, action: AnyAction) => {
        if (action.type === getType(resetState)) {
            return action.payload;
        }

        return rootReducer(state, action);
    };
}
