import {takeEvery, put, call} from 'redux-saga/effects';
import {Action} from 'typesafe-actions';
import {AxiosError} from 'axios';

import {SagaIterator} from '@redux-saga/types';

import * as passengersActions from 'reducers/account/passengers/actions';
import * as docActions from 'reducers/account/docs/actions';

import {
    addDocument,
    editDocument,
    removeDocument,
} from 'utilities/passengerApiMethods/passengerApiMethods';

const makeErrorAction = (error: AxiosError): Action =>
    error.response && error.response.status === 401
        ? passengersActions.authErrorPassenger()
        : passengersActions.failPassenger();

function* docAdd(
    action: ReturnType<typeof docActions.addDocument>,
): SagaIterator {
    yield put(docActions.processDocument(action.payload));

    try {
        const result = yield call(addDocument, action.payload);

        yield put(docActions.addDocumentSuccess(result.data));
    } catch (e) {
        yield put(makeErrorAction(e as AxiosError));
    }
}

function* docEdit(
    action: ReturnType<typeof docActions.editDocument>,
): SagaIterator {
    yield put(docActions.processDocument(action.payload));

    try {
        const result = yield call(editDocument, action.payload);

        yield put(docActions.editDocumentSuccess(result.data));
    } catch (e) {
        yield put(makeErrorAction(e as AxiosError));
    }
}

function* docRemove(
    action: ReturnType<typeof docActions.removeDocument>,
): SagaIterator {
    yield put(docActions.processDocument(action.payload));

    try {
        yield call(removeDocument, action.payload);

        yield put(docActions.removeDocumentSuccess(action.payload));
    } catch (e) {
        yield put(makeErrorAction(e as AxiosError));
    }
}

export default function* (): SagaIterator {
    yield takeEvery(docActions.removeDocument, docRemove);
    yield takeEvery(docActions.editDocument, docEdit);
    yield takeEvery(docActions.addDocument, docAdd);
}
