import {ORDER_TYPE_VALUES} from 'projects/account/lib/orders/types';
import IGenericOrderGetOrderApiResponse from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiResponse';
import EGenericOrderSource from 'server/api/GenericOrderApi/types/common/EGenericOrderSource';

import convertTrainApiOrderToGenericOrder from 'projects/trains/lib/api/utilities/convertTrainApiOrderToGenericOrder/convertTrainApiOrderToGenericOrder';

import {trainsBrowserProvider} from 'serviceProvider/trains/trainsBrowserProvider';
import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export default async function fetchTrainOrder(
    orderId: string,
    trainsOrderType:
        | ORDER_TYPE_VALUES.TRAINS
        | ORDER_TYPE_VALUES.TRAINS_GENERIC,
): Promise<IGenericOrderGetOrderApiResponse> {
    switch (trainsOrderType) {
        case ORDER_TYPE_VALUES.TRAINS: {
            const order =
                await trainsBrowserProvider.getActualizedTrainApiOrder({
                    orderId,
                });

            return convertTrainApiOrderToGenericOrder(order);
        }
        case ORDER_TYPE_VALUES.TRAINS_GENERIC: {
            return genericOrderBrowserProvider.getOrder({
                orderId,
                source: EGenericOrderSource.ORDER_PAGE,
            });
        }
    }
}
